/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import java.util.ArrayList;

public class FontSelector {
    protected ArrayList fonts = new ArrayList();

    public void addFont(Font font) {
        if (font.getBaseFont() != null) {
            this.fonts.add(font);
            return;
        }
        BaseFont bf = font.getCalculatedBaseFont(true);
        Font f2 = new Font(bf, font.size(), font.getCalculatedStyle(), font.color());
        this.fonts.add(f2);
    }

    public Phrase process(String text) {
        int fsize = this.fonts.size();
        if (fsize == 0) {
            throw new IndexOutOfBoundsException("No font is defined.");
        }
        char[] cc = text.toCharArray();
        int len = cc.length;
        StringBuffer sb = new StringBuffer();
        Font font = null;
        int lastidx = -1;
        Phrase ret = new Phrase();
        int k = 0;
        while (k < len) {
            char c = cc[k];
            if (c == '\n' || c == '\r') {
                sb.append(c);
            } else {
                int f = 0;
                while (f < fsize) {
                    font = (Font)this.fonts.get(f);
                    if (font.getBaseFont().charExists(c)) {
                        if (lastidx == f) {
                            sb.append(c);
                            break;
                        }
                        if (sb.length() > 0 && lastidx != -1) {
                            Chunk ck = new Chunk(sb.toString(), (Font)this.fonts.get(lastidx));
                            ret.add(ck);
                            sb = new StringBuffer();
                        }
                        sb.append(c);
                        lastidx = f;
                        break;
                    }
                    ++f;
                }
            }
            ++k;
        }
        if (sb.length() > 0) {
            Chunk ck = new Chunk(sb.toString(), (Font)this.fonts.get(lastidx));
            ret.add(ck);
        }
        return ret;
    }
}

