/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.OSMainTabbedPane;
import com.rameses.osiris3.platform.OSPlatform;
import com.rameses.platform.interfaces.ContentPane;
import com.rameses.platform.interfaces.SubWindow;
import com.rameses.platform.interfaces.SubWindowListener;
import com.rameses.platform.interfaces.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.server.UID;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

class OSTabbedView
extends JPanel
implements SubWindow,
ContentPane {
    private String id;
    private String title;
    private boolean canClose = true;
    private ViewContext viewContext;
    private OSPlatform platform;
    private SubWindowListener listener;

    public OSTabbedView(String id, Component comp, OSPlatform platform) {
        this(id, comp, platform, true);
    }

    public OSTabbedView(String id, Component comp, OSPlatform platform, boolean canClose) {
        this.id = id == null ? "WIN" + new UID() : id;
        this.platform = platform;
        this.canClose = canClose;
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSTabbedView.this.close();
            }
        }, KeyStroke.getKeyStroke("ctrl W"), 2);
        if (comp instanceof ViewContext) {
            this.viewContext = (ViewContext)((Object)comp);
            this.viewContext.setSubWindow(this);
        }
        this.setLayout(new BorderLayout());
        this.add(comp);
    }

    @Override
    public void close() {
        if (!this.canClose) {
            return;
        }
        if (this.viewContext != null && !this.viewContext.close()) {
            return;
        }
        Container p = this.getParent();
        if (p instanceof OSMainTabbedPane) {
            ((OSMainTabbedPane)p).remove(this);
        }
    }

    @Override
    public boolean isCanClose() {
        return this.canClose;
    }

    public void setCanClose(boolean canClose) {
        this.canClose = canClose;
    }

    @Override
    public void activate() {
        Container p = this.getParent();
        if (p instanceof OSMainTabbedPane) {
            ((OSMainTabbedPane)p).setSelectedComponent(this);
        }
    }

    @Override
    public ContentPane.View getView() {
        Component[] comps;
        for (Component c : comps = this.getComponents()) {
            if (!(c instanceof ContentPane.View)) continue;
            return (ContentPane.View)((Object)c);
        }
        return null;
    }

    @Override
    public void setListener(SubWindowListener listener) {
        this.listener = listener;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        if (this.listener != null) {
            this.listener.fireUpdate(this);
        }
    }

    @Override
    public void closeWindow() {
        this.close();
    }

    @Override
    public void update(Map attrs) {
        Object otitle;
        if (attrs == null || attrs.isEmpty()) {
            return;
        }
        Object oid = attrs.remove("id");
        if (oid != null) {
            this.id = oid.toString();
        }
        if ((otitle = attrs.remove("title")) != null) {
            this.title = otitle.toString();
        }
        if (this.listener != null) {
            this.listener.fireUpdate(this);
        }
    }
}

