/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.FrameReportElement;
import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.ReportReader;
import it.businesslogic.ireport.ReportWriter;
import it.businesslogic.ireport.ScriptletCode;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.Template;
import it.businesslogic.ireport.TransformationType;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportDocumentStatusChangedEvent;
import it.businesslogic.ireport.gui.event.ReportDocumentStatusChangedListener;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedEvent;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedListener;
import it.businesslogic.ireport.gui.event.StyleChangedEvent;
import it.businesslogic.ireport.gui.event.StyleChangedListener;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedEvent;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedListener;
import it.businesslogic.ireport.gui.event.TemplateChangedEvent;
import it.businesslogic.ireport.refactoring.ReportRefactor;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import it.businesslogic.ireport.util.TreeNode;
import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Report
extends SubDataset
implements SubDatasetObjectChangedListener {
    public static int SCRIPTLET_IREPORT_INTERNAL_HANDLING = 1;
    public static int SCRIPTLET_NOT_USED = 0;
    public static int SCRIPTLET_CLASSIC_HANDLING = 2;
    private int nextGroupId = 0;
    private IReportFont defaultFont = new IReportFont();
    private boolean readOnly = false;
    private int height = 0;
    private int width = 0;
    private Vector elements = new Vector();
    private Vector bands = new Vector();
    private Vector imports = new Vector();
    private Vector templates = new Vector();
    private String filename = "";
    private Vector subDatasets = new Vector();
    private String encoding = "UTF-8";
    private int columnCount = 1;
    private String printOrder = "Vertical";
    private String orientation = "Portrait";
    private String whenNoDataType = "NoPages";
    private int columnWidth = 535;
    private int columnSpacing = 0;
    private int leftMargin = 20;
    private int rightMargin = 20;
    private int topMargin = 30;
    private int bottomMargin = 30;
    private boolean isTitleNewPage = false;
    private boolean isSummaryNewPage = false;
    private long loadTime = 0L;
    private Vector fonts = new Vector();
    private Vector styles = new Vector();
    private JReportFrame reportFrame;
    private String reportFormat;
    static int untitledId = 1;
    private int reportChanges = 1;
    private boolean floatColumnFooter = false;
    private boolean ignorePagination = false;
    protected boolean usingMultiLineExpressions = false;
    private String language = "java";
    private ScriptletCode scripletCode;
    private int scriptletHandling = 2;
    private HashMap proposedValues = null;
    private boolean loadingFile = false;
    private String formatFactoryClass = "";
    private EventListenerList listenerList = null;

    public Vector getTemplates() {
        return this.templates;
    }

    public void setTemplates(Vector templates) {
        this.templates = templates;
    }

    public Report() {
        this.setName(I18n.getString("untitledReport", "untitled_report_") + untitledId);
        ++untitledId;
        this.proposedValues = new HashMap();
        this.getKeywordLookup().addKeyword("$R{*}");
        this.bands.addElement(new Band(this, "background", 0));
        this.bands.addElement(new Band(this, "title", 50));
        this.bands.addElement(new Band(this, "pageHeader", 50));
        this.bands.addElement(new Band(this, "columnHeader", 30));
        this.bands.addElement(new Band(this, "detail", 100));
        this.bands.addElement(new Band(this, "columnFooter", 30));
        this.bands.addElement(new Band(this, "pageFooter", 50));
        this.bands.addElement(new Band(this, "lastPageFooter", 50));
        this.bands.addElement(new Band(this, "summary", 50));
        this.bands.addElement(new Band(this, "noData", 0));
        this.addImport("java.util.*");
        this.addImport("net.sf.jasperreports.engine.*");
        this.addImport("net.sf.jasperreports.engine.data.*");
        try {
            this.scripletCode = new ScriptletCode(ScriptletCode.class.getClassLoader().getResourceAsStream("scriptlet_template.jav"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLanguage(MainFrame.getMainInstance().getProperties().getProperty("DefaultScriptingLanguage", "java"));
        this.addSubDatasetObjectChangedListener(this);
        String rDefStyle = MainFrame.getMainInstance().getProperties().getProperty("DefaultStyle", "");
        if (rDefStyle.length() > 0) {
            Vector stylesLib = MainFrame.getMainInstance().getStyleLibrarySet();
            for (int i = 0; i < stylesLib.size(); ++i) {
                Style s = (Style)stylesLib.get(i);
                if (s.getName() == null || !s.getName().equals(rDefStyle)) continue;
                Style s1 = new Style(s);
                s1.getAttributes().put("isDefault", "true");
                this.addStyle(s1);
            }
        }
    }

    public Report(String xmlFile) throws Exception {
        this();
        --untitledId;
        while (this.getStyles().size() > 0) {
            this.removeStyle((Style)this.getStyles().get(0));
        }
        ReportReader rr = new ReportReader(this);
        rr.readFile(xmlFile);
    }

    public static String readPCDATA(Node textNode) {
        return Report.readPCDATA(textNode, true);
    }

    public static String readPCDATA(Node textNode, boolean trim) {
        NodeList list_child = textNode.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            short nt;
            Node child_child = list_child.item(ck);
            Node ns = child_child.getNextSibling();
            if (ns != null) {
                child_child = ns;
            }
            if ((nt = child_child.getNodeType()) != 4 && nt != 3) continue;
            if (trim) {
                return child_child.getNodeValue().trim();
            }
            return child_child.getNodeValue();
        }
        return "";
    }

    static Color decodeColor(String colorString) {
        Color color = null;
        char firstChar = colorString.charAt(0);
        color = firstChar == '#' ? new Color(Integer.parseInt(colorString.substring(1), 16)) : ('0' <= firstChar && firstChar <= '9' ? new Color(Integer.parseInt(colorString)) : (JRXmlConstants.getColorMap().containsKey(colorString) ? (Color)JRXmlConstants.getColorMap().get(colorString) : Color.black));
        return color;
    }

    public String createChildGroup(String parentElementGroup) {
        ++this.nextGroupId;
        if (parentElementGroup.length() > 0) {
            parentElementGroup = parentElementGroup + ".";
        }
        return parentElementGroup + this.nextGroupId;
    }

    public Vector getBands() {
        return this.bands;
    }

    public void setBands(Vector bands) {
        this.bands = bands;
        this.incrementReportChanges();
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(int bottomMargin) {
        if (this.bottomMargin == bottomMargin) {
            return;
        }
        this.bottomMargin = bottomMargin;
        this.incrementReportChanges();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        if (this.columnCount == columnCount) {
            return;
        }
        this.columnCount = columnCount;
        this.incrementReportChanges();
    }

    public int getColumnSpacing() {
        return this.columnSpacing;
    }

    public void setColumnSpacing(int columnSpacing) {
        if (this.columnSpacing == columnSpacing) {
            return;
        }
        this.columnSpacing = columnSpacing;
        this.incrementReportChanges();
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(int columnWidth) {
        if (this.columnWidth == columnWidth) {
            return;
        }
        this.columnWidth = columnWidth;
        this.incrementReportChanges();
    }

    public Vector getElements() {
        return this.elements;
    }

    public void setElements(Vector elements) {
        this.elements = elements;
        this.incrementReportChanges();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (this.encoding == null ? encoding == null : this.encoding.equals(encoding)) {
            return;
        }
        this.encoding = encoding;
        this.incrementReportChanges();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Vector getFonts() {
        return this.fonts;
    }

    public void setFonts(Vector fonts) {
        this.fonts = fonts;
        this.incrementReportChanges();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (this.height == height) {
            return;
        }
        this.height = height;
        this.incrementReportChanges();
    }

    public boolean isIsSummaryNewPage() {
        return this.isSummaryNewPage;
    }

    public void setIsSummaryNewPage(boolean isSummaryNewPage) {
        if (this.isSummaryNewPage == isSummaryNewPage) {
            return;
        }
        this.isSummaryNewPage = isSummaryNewPage;
        this.incrementReportChanges();
    }

    public boolean isIsTitleNewPage() {
        return this.isTitleNewPage;
    }

    public void setIsTitleNewPage(boolean isTitleNewPage) {
        if (this.isTitleNewPage == isTitleNewPage) {
            return;
        }
        this.isTitleNewPage = isTitleNewPage;
        this.incrementReportChanges();
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int leftMargin) {
        if (this.leftMargin == leftMargin) {
            return;
        }
        this.leftMargin = leftMargin;
        this.incrementReportChanges();
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public void setLoadTime(long loadTime) {
        this.loadTime = loadTime;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        if (this.orientation == null ? orientation == null : this.orientation.equals(orientation)) {
            return;
        }
        this.orientation = orientation;
        this.incrementReportChanges();
    }

    public String getPrintOrder() {
        return this.printOrder;
    }

    public void setPrintOrder(String printOrder) {
        if (this.printOrder == null ? printOrder == null : this.printOrder.equals(printOrder)) {
            return;
        }
        this.printOrder = printOrder;
        this.incrementReportChanges();
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(int rightMargin) {
        if (this.rightMargin == rightMargin) {
            return;
        }
        this.rightMargin = rightMargin;
        this.incrementReportChanges();
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int topMargin) {
        if (this.topMargin == topMargin) {
            return;
        }
        this.topMargin = topMargin;
        this.incrementReportChanges();
    }

    public void addImport(String _import) {
        if (!this.imports.contains(_import)) {
            this.imports.add(_import);
            this.incrementReportChanges();
        }
    }

    public String getWhenNoDataType() {
        return this.whenNoDataType;
    }

    public void setWhenNoDataType(String whenNoDataType) {
        if (this.whenNoDataType == null ? whenNoDataType == null : this.whenNoDataType.equals(whenNoDataType)) {
            return;
        }
        this.whenNoDataType = whenNoDataType;
        this.incrementReportChanges();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (this.width == width) {
            return;
        }
        this.width = width;
        this.incrementReportChanges();
    }

    public int getBandYLocation(Band b) {
        Band band;
        int y = this.topMargin;
        Iterator i = this.bands.iterator();
        while (i.hasNext() && (band = (Band)i.next()) != b) {
            y += band.getHeight();
        }
        return y;
    }

    public JReportFrame getReportFrame() {
        return this.reportFrame;
    }

    public void setReportFrame(JReportFrame reportFrame) {
        this.reportFrame = reportFrame;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public int getDesignHeight() {
        int y = this.topMargin + this.bottomMargin;
        Iterator i = this.bands.iterator();
        while (i.hasNext()) {
            y += ((Band)i.next()).getHeight();
        }
        return y;
    }

    public int getDesignHeightNoBG() {
        int y = 0;
        y += this.topMargin;
        y += this.bottomMargin;
        for (Band b : this.bands) {
            if (b.getName().equals("background")) continue;
            y += b.getHeight();
        }
        return y;
    }

    public void addGroup(Group grp) {
        this.addGroup(grp, true);
    }

    public void addGroup(Group grp, boolean adjust) {
        this.incrementReportChanges();
        if (!this.getGroups().contains(grp)) {
            this.getGroups().addElement(grp);
        }
        String bandsstr = "";
        for (int i = 0; i < this.bands.size(); ++i) {
            Band b = (Band)this.bands.elementAt(i);
            if (!b.getName().equals("detail")) continue;
            if (adjust) {
                int bandYLocation = this.getBandYLocation(b);
                for (ReportElement elem : this.elements) {
                    int delta_y = grp.getGroupHeader().getHeight();
                    if (elem.band == grp.getGroupHeader() || elem.band == grp.getGroupFooter()) continue;
                    if (elem.position.y >= bandYLocation + 10 + b.getHeight()) {
                        elem.trasform(new Point(0, delta_y += grp.getGroupFooter().getHeight()), TransformationType.TRANSFORMATION_MOVE);
                        continue;
                    }
                    if (elem.position.y < bandYLocation + 10) continue;
                    elem.trasform(new Point(0, delta_y), TransformationType.TRANSFORMATION_MOVE);
                }
            }
            this.bands.insertElementAt(grp.getGroupHeader(), i);
            this.bands.insertElementAt(grp.getGroupFooter(), i + 2);
            break;
        }
        this.addVariable(new JRVariable(grp.getName() + "_COUNT", "java.lang.Integer", true));
    }

    public synchronized void moveGroup(Group grp, int direction) {
        Group grpOne = null;
        Group grpTwo = null;
        if (this.getGroups().size() <= 1) {
            return;
        }
        this.incrementReportChanges();
        if (direction == 1) {
            if (this.getGroups().lastElement() == grp) {
                return;
            }
            grpOne = grp;
            grpTwo = (Group)this.getGroups().get(this.getGroups().indexOf(grp) + 1);
        } else {
            if (this.getGroups().firstElement() == grp) {
                return;
            }
            grpTwo = grp;
            grpOne = (Group)this.getGroups().get(this.getGroups().indexOf(grp) - 1);
        }
        Band bandGrpOneHeader = this.getBandByName(grpOne.getGroupHeader().getName());
        Band bandGrpTwoHeader = this.getBandByName(grpTwo.getGroupHeader().getName());
        Band bandGrpOneFooter = this.getBandByName(grpOne.getGroupFooter().getName());
        Band bandGrpTwoFooter = this.getBandByName(grpTwo.getGroupFooter().getName());
        int delta1 = bandGrpOneHeader.getHeight();
        int delta2 = bandGrpTwoHeader.getHeight();
        int delta3 = bandGrpOneFooter.getHeight();
        int delta4 = bandGrpTwoFooter.getHeight();
        for (ReportElement re : this.elements) {
            if (re.band == bandGrpOneHeader) {
                re.trasform(new Point(0, delta2), TransformationType.TRANSFORMATION_MOVE);
                continue;
            }
            if (re.band == bandGrpTwoHeader) {
                re.trasform(new Point(0, -delta1), TransformationType.TRANSFORMATION_MOVE);
                continue;
            }
            if (re.band == bandGrpTwoFooter) {
                re.trasform(new Point(0, delta3), TransformationType.TRANSFORMATION_MOVE);
                continue;
            }
            if (re.band != bandGrpOneFooter) continue;
            re.trasform(new Point(0, -delta4), TransformationType.TRANSFORMATION_MOVE);
        }
        int pos1 = this.bands.indexOf(bandGrpOneHeader);
        Band bandBuffer = (Band)this.bands.get(pos1);
        this.bands.remove(pos1);
        this.bands.insertElementAt(bandBuffer, pos1 + 1);
        int pos3 = this.bands.indexOf(bandGrpTwoFooter);
        bandBuffer = (Band)this.bands.get(pos3);
        this.bands.remove(pos3);
        this.bands.insertElementAt(bandBuffer, pos3 + 1);
        int groupPos = this.getGroups().indexOf(grpOne);
        Group groupBuffer = (Group)this.getGroups().get(groupPos);
        this.getGroups().remove(groupPos);
        this.getGroups().insertElementAt(groupBuffer, groupPos + 1);
    }

    public void delGroup(Group grp) {
        int i;
        if (!this.getGroups().contains(grp)) {
            return;
        }
        this.incrementReportChanges();
        String bandsstr = "";
        for (i = 0; i < this.getVariables().size(); ++i) {
            JRVariable var = (JRVariable)this.getVariables().elementAt(i);
            if (!var.isBuiltin() || !var.getName().equalsIgnoreCase(grp.getName() + "_COUNT")) continue;
            this.removeVariable(var);
            break;
        }
        for (i = 0; i < this.elements.size(); ++i) {
            ReportElement elem = (ReportElement)this.elements.elementAt(i);
            if (elem.getBand() == grp.getGroupHeader() || elem.getBand() == grp.getGroupFooter()) {
                this.elements.removeElementAt(i);
                --i;
                continue;
            }
            int delta_y = grp.getGroupHeader().getHeight();
            if (elem.position.y >= this.getBandYLocation(grp.getGroupFooter()) + 10 + grp.getGroupFooter().getHeight()) {
                elem.trasform(new Point(0, -(delta_y += grp.getGroupFooter().getHeight())), TransformationType.TRANSFORMATION_MOVE);
                continue;
            }
            if (elem.position.y < this.getBandYLocation(grp.getGroupHeader()) + 10 + grp.getGroupHeader().getHeight()) continue;
            elem.trasform(new Point(0, -delta_y), TransformationType.TRANSFORMATION_MOVE);
        }
        this.bands.removeElement(grp.getGroupHeader());
        this.bands.removeElement(grp.getGroupFooter());
        this.getGroups().removeElement(grp);
    }

    public Group getGroupByName(String name) {
        for (int i = 0; i < this.getGroups().size(); ++i) {
            Group grp = (Group)this.getGroups().elementAt(i);
            if (!grp.getName().equals(name)) continue;
            return grp;
        }
        return null;
    }

    public Band getBandByName(String name) {
        for (int i = 0; i < this.bands.size(); ++i) {
            Band band = (Band)this.bands.elementAt(i);
            if (!band.getName().equals(name)) continue;
            return band;
        }
        return null;
    }

    public void saveXMLFile() {
        this.saveXMLFile(this.getFilename());
    }

    public void saveXMLFile(String aFilename) {
        if (this.isReadOnly()) {
            JOptionPane.showMessageDialog(this.getReportFrame().getMainFrame(), I18n.getString("fileReadOnly", "File is read only and cannot be saved."), I18n.getString("save", "Save"), 1);
            return;
        }
        ReportWriter wr = new ReportWriter(this);
        wr.saveXMLFile(aFilename);
    }

    public boolean isUsingMultiLineExpressions() {
        return false;
    }

    public void setUsingMultiLineExpressions(boolean usingMultiLineExpressions) {
        this.usingMultiLineExpressions = false;
    }

    public ScriptletCode getScripletCode() {
        return this.scripletCode;
    }

    public void setScripletCode(ScriptletCode scripletCode) {
        this.scripletCode = scripletCode;
    }

    public int getScriptletHandling() {
        return this.scriptletHandling;
    }

    public void setScriptletHandling(int scriptletHandling) {
        if (this.scriptletHandling == scriptletHandling) {
            return;
        }
        this.scriptletHandling = scriptletHandling;
        this.incrementReportChanges();
    }

    public String getScriptletFileName() {
        return this.getScriptletFileName(this.getFilename());
    }

    public String getScriptletFileName(String file) {
        if (file == null) {
            return "Scriptlet.java";
        }
        if (file.length() > 3) {
            file = Misc.changeFileExtension(file, "");
            file = file.substring(0, file.length() - 1);
            File f = new File(file);
            String className = f.getName() + "Scriptlet";
            className = Misc.string_replace("_", ".", className);
            if (Character.isDigit((className = Misc.string_replace("_", " ", className)).charAt(0))) {
                className = "_" + className;
            }
            className = className + ".java";
            return f.getPath().substring(0, f.getPath().length() - f.getName().length()) + className;
        }
        return "Scriptlet.java";
    }

    public IReportFont getDefaultFont() {
        return this.defaultFont;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void checkReadOnlyFlag() {
        this.checkReadOnlyFlag(this.getFilename());
    }

    public void checkReadOnlyFlag(String oF) {
        if (oF == null) {
            return;
        }
        File f = new File(oF);
        try {
            this.readOnly = !f.exists() ? false : !f.canWrite();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.readOnly = false;
    }

    public Band getBandByPosition(int originY) {
        Band bname = null;
        for (Band b : this.getBands()) {
            if (this.getBandYLocation(b) + 10 > originY) continue;
            bname = b;
        }
        if (bname != null && this.getBandYLocation(bname) + 10 + bname.getHeight() < originY) {
            return null;
        }
        return bname;
    }

    public Vector getImports() {
        return this.imports;
    }

    public void setImports(Vector imports) {
        this.imports = imports;
        this.incrementReportChanges();
    }

    public boolean isFloatColumnFooter() {
        return this.floatColumnFooter;
    }

    public void setFloatColumnFooter(boolean floatColumnFooter) {
        if (this.floatColumnFooter == floatColumnFooter) {
            return;
        }
        this.floatColumnFooter = floatColumnFooter;
        this.incrementReportChanges();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        if (this.language == null ? language == null : this.language.equals(language)) {
            return;
        }
        this.language = language;
        this.incrementReportChanges();
    }

    public HashMap getProposedValues() {
        return this.proposedValues;
    }

    public void setProposedValues(HashMap proposedValues) {
        this.proposedValues = proposedValues;
    }

    public void recalcColumnWidth() {
        int avail;
        int dim = avail = this.getWidth() - this.getLeftMargin() - this.getRightMargin() - (this.getColumnCount() - 1) * this.getColumnSpacing();
        dim = (int)((double)dim / (double)this.getColumnCount());
        while (dim * this.getColumnCount() > avail) {
            --dim;
        }
        this.setColumnWidth(dim);
    }

    public IReportFont getReportFontByName(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        for (int i = 0; i < this.getFonts().size(); ++i) {
            IReportFont font = (IReportFont)this.getFonts().elementAt(i);
            if (!font.getReportFont().equals(name)) continue;
            return font;
        }
        return null;
    }

    public Vector getStyles() {
        return this.styles;
    }

    public void setStyles(Vector styles) {
        this.styles = styles;
        this.incrementReportChanges();
    }

    public void elementGroupResort(Band band) {
        TreeNode root = this.extractBandElementsTree(band, true);
        this.addElementsTree(root);
        this.incrementReportChanges();
    }

    public TreeNode extractBandElementsTree(Band band, boolean remove) {
        ReportElement element;
        int i;
        ArrayList<ReportElement> tmpElements = new ArrayList<ReportElement>();
        TreeNode root = new TreeNode("");
        for (i = 0; i < this.getElements().size(); ++i) {
            element = (ReportElement)this.getElements().elementAt(i);
            if (element.getBand() != band) continue;
            tmpElements.add(element);
            if (!remove) continue;
            this.getElements().removeElementAt(i);
            --i;
        }
        if (tmpElements.size() > 0) {
            for (i = 0; i < tmpElements.size(); ++i) {
                element = (ReportElement)tmpElements.get(i);
                String elementGroup = element.getElementGroup();
                try {
                    if (element.getParentElement() != null) {
                        TreeNode tmpRoot = this.findElementInTreeNode(root, element.getParentElement());
                        if (tmpRoot == null) continue;
                        this.addElementToGroup(tmpRoot, elementGroup, element);
                        continue;
                    }
                    this.addElementToGroup(root, elementGroup, element);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return root;
    }

    public void moveElementDown(ReportElement element) {
        this.incrementReportChanges();
        TreeNode root = this.extractBandElementsTree(element.getBand(), true);
        root.moveDown(element);
        this.addElementsTree(root);
    }

    public void moveElementUp(ReportElement element) {
        this.incrementReportChanges();
        TreeNode root = this.extractBandElementsTree(element.getBand(), true);
        root.moveUp(element);
        this.addElementsTree(root);
    }

    private void addElementsTree(TreeNode root) {
        for (int i = 0; i < root.getChilds().size(); ++i) {
            TreeNode node = (TreeNode)root.getChilds().get(i);
            Object obj = node.getUserObject();
            if (obj instanceof ReportElement) {
                this.getElements().add(obj);
                if (!(obj instanceof FrameReportElement)) continue;
                this.addElementsTree(node);
                continue;
            }
            this.addElementsTree(node);
        }
    }

    public void addElementToGroup(TreeNode parentNode, String subGroup, ReportElement element) {
        this.incrementReportChanges();
        if (subGroup.equals("")) {
            parentNode.addChild(new TreeNode(element));
            return;
        }
        String levelGroupName = "";
        if (subGroup.indexOf(".") >= 0) {
            levelGroupName = subGroup.substring(0, subGroup.indexOf("."));
            subGroup = subGroup.substring(subGroup.indexOf(".") + 1);
        } else {
            levelGroupName = subGroup;
            subGroup = "";
        }
        for (int i = 0; i < parentNode.getChilds().size(); ++i) {
            TreeNode node = (TreeNode)parentNode.getChilds().get(i);
            if (!node.getName().equals(levelGroupName)) continue;
            this.addElementToGroup(node, subGroup, element);
            return;
        }
        TreeNode nl = new TreeNode(levelGroupName);
        this.addElementToGroup(nl, subGroup, element);
        parentNode.addChild(nl);
    }

    public TreeNode findElementInTreeNode(TreeNode parentNode, ReportElement re) {
        for (int k = 0; k < parentNode.getChilds().size(); ++k) {
            TreeNode newchild;
            TreeNode child = (TreeNode)parentNode.getChilds().get(k);
            if (child.getUserObject() == re) {
                return child;
            }
            if (!re.getElementGroup().equals("") && re.getParentElement() == null || !(child.getUserObject() instanceof FrameReportElement) && !(child.getUserObject() instanceof String) || (newchild = this.findElementInTreeNode(child, re)) == null) continue;
            return newchild;
        }
        return null;
    }

    public Vector getSubDatasets() {
        return this.subDatasets;
    }

    public void setSubDatasets(Vector subDatasets) {
        this.subDatasets = subDatasets;
        this.incrementReportChanges();
    }

    public boolean isIgnorePagination() {
        return this.ignorePagination;
    }

    public void setIgnorePagination(boolean ignorePagination) {
        if (this.ignorePagination == ignorePagination) {
            return;
        }
        this.ignorePagination = ignorePagination;
        this.incrementReportChanges();
    }

    public void addSubDataset(SubDataset subDataset) {
        this.getSubDatasets().add(subDataset);
        this.incrementReportChanges();
        this.fireReportSubDatasetChangedListenerReportSubDatasetChanged(new ReportSubDatasetChangedEvent(this, subDataset, 2, 1));
        subDataset.addSubDatasetObjectChangedListener(this);
    }

    public void removeSubDataset(SubDataset subDataset) {
        this.getSubDatasets().remove(subDataset);
        this.fireReportSubDatasetChangedListenerReportSubDatasetChanged(new ReportSubDatasetChangedEvent(this, subDataset, 1, 1));
        subDataset.removeSubDatasetObjectChangedListener(this);
        this.incrementReportChanges();
    }

    public void removeStyle(Style s) {
        this.getStyles().remove(s);
        this.removeStyleFromElements(s, this.getElements());
        this.fireStyleChangedListenerStyleChanged(new StyleChangedEvent(this, 2, s, s));
        this.incrementReportChanges();
    }

    public void removeTemplate(Template t) {
        this.getTemplates().remove(t);
        this.fireStyleChangedListenerTemplateChanged(new TemplateChangedEvent(this, 2, t, t));
        this.incrementReportChanges();
    }

    public void addTemplate(Template t) {
        this.getTemplates().add(t);
        this.fireStyleChangedListenerTemplateChanged(new TemplateChangedEvent(this, 0, t, t));
        this.incrementReportChanges();
    }

    public void addStyle(Style s) {
        this.getStyles().add(s);
        this.incrementReportChanges();
        this.fireStyleChangedListenerStyleChanged(new StyleChangedEvent(this, 0, s, s));
    }

    private void removeStyleFromElements(Style s, Vector thisElements) {
        for (int i = 0; i < thisElements.size(); ++i) {
            ReportElement re = (ReportElement)thisElements.elementAt(i);
            if (re.getStyle() == s) {
                re.setStyle(null);
            }
            if (!(re instanceof CrosstabReportElement)) continue;
            this.removeStyleFromElements(s, ((CrosstabReportElement)re).getElements());
        }
        this.incrementReportChanges();
    }

    public synchronized void addReportSubDatasetChangedListener(ReportSubDatasetChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ReportSubDatasetChangedListener.class, listener);
    }

    public synchronized void removeReportSubDatasetChangedListener(ReportSubDatasetChangedListener listener) {
        this.listenerList.remove(ReportSubDatasetChangedListener.class, listener);
    }

    public void fireReportSubDatasetChangedListenerReportSubDatasetChanged(ReportSubDatasetChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReportSubDatasetChangedListener.class) continue;
            ((ReportSubDatasetChangedListener)listeners[i + 1]).reportSubDatasetChanged(event);
        }
    }

    public void subDatasetObjectChanged(SubDatasetObjectChangedEvent evt) {
        String newString;
        String oldString;
        Vector changedElements = new Vector();
        if (evt.getType() == 0) {
            if (evt.getAction() == 1 && evt.getSource() instanceof SubDataset) {
                oldString = "$F{" + evt.getOldValue() + "}";
                newString = "$F{" + evt.getNewValue() + "}";
                if (evt.getOldValue() != null && evt.getNewValue() != null && !oldString.equals(newString)) {
                    System.out.println("replaceInReportExpressions for DS= " + evt.getSource());
                    ReportRefactor.replaceInReportExpressions(oldString, newString, evt.getSource(), this);
                }
                if (evt.getSource() == this && !((JRField)evt.getOldValue()).getClassType().equals(((JRField)evt.getNewValue()).getClassType())) {
                    changedElements.addAll(ReportRefactor.replaceTextfieldClass("$F{" + evt.getNewValue() + "}", ((JRField)evt.getNewValue()).getClassType(), this.getElements()));
                }
            }
        }
        if (evt.getType() == 2) {
            if (evt.getAction() == 1 && evt.getSource() instanceof SubDataset) {
                oldString = "$P{" + evt.getOldValue() + "}";
                newString = "$P{" + evt.getNewValue() + "}";
                if (evt.getOldValue() != null && evt.getNewValue() != null && !oldString.equals(newString)) {
                    ReportRefactor.replaceInReportExpressions(oldString, newString, evt.getSource(), this);
                }
                if (evt.getSource() == this && !((JRParameter)evt.getOldValue()).getClassType().equals(((JRParameter)evt.getNewValue()).getClassType())) {
                    changedElements.addAll(ReportRefactor.replaceTextfieldClass("$P{" + evt.getNewValue() + "}", ((JRParameter)evt.getNewValue()).getClassType(), this.getElements()));
                }
            }
        }
        if (evt.getType() == 1) {
            if (evt.getAction() == 1 && evt.getSource() instanceof SubDataset) {
                oldString = "$V{" + evt.getOldValue() + "}";
                newString = "$V{" + evt.getNewValue() + "}";
                if (evt.getOldValue() != null && evt.getNewValue() != null && !oldString.equals(newString)) {
                    ReportRefactor.replaceInReportExpressions(oldString, newString, evt.getSource(), this);
                }
                if (evt.getSource() == this && !((JRVariable)evt.getOldValue()).getClassType().equals(((JRVariable)evt.getNewValue()).getClassType())) {
                    changedElements.addAll(ReportRefactor.replaceTextfieldClass("$V{" + evt.getNewValue() + "}", ((JRVariable)evt.getNewValue()).getClassType(), this.getElements()));
                }
            }
        }
        if (changedElements.size() > 0) {
            System.out.flush();
            this.getReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.getReportFrame(), changedElements, 3));
            MainFrame.getMainInstance().getElementPropertiesDialog().updateSelection();
        }
        if (this.getListenerList() != null && evt.getSource() != this) {
            Object[] listeners = this.getListenerList().getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i + 1] == this || listeners[i] != SubDatasetObjectChangedListener.class) continue;
                ((SubDatasetObjectChangedListener)listeners[i + 1]).subDatasetObjectChanged(evt);
            }
        }
        this.incrementReportChanges();
    }

    public synchronized void addStyleChangedListener(StyleChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(StyleChangedListener.class, listener);
    }

    public synchronized void removeStyleChangedListener(StyleChangedListener listener) {
        this.listenerList.remove(StyleChangedListener.class, listener);
    }

    public void fireStyleChangedListenerStyleChanged(StyleChangedEvent event) {
        Enumeration enum_elements = this.getElements().elements();
        while (enum_elements.hasMoreElements()) {
            ReportElement re = (ReportElement)enum_elements.nextElement();
            if (re.getStyle() != event.getNewValue()) continue;
            re.setStyle(event.getNewValue());
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StyleChangedListener.class) continue;
            ((StyleChangedListener)listeners[i + 1]).styleChanged(event);
        }
    }

    public void fireStyleChangedListenerTemplateChanged(TemplateChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StyleChangedListener.class) continue;
            ((StyleChangedListener)listeners[i + 1]).templateChanged(event);
        }
    }

    public Style getDefaultStyle() {
        for (int i = 0; i < this.getStyles().size(); ++i) {
            Style s = (Style)this.getStyles().elementAt(i);
            if (!s.getAttributeBoolean("isDefault", false)) continue;
            return s;
        }
        return null;
    }

    public int getReportChanges() {
        return this.reportChanges;
    }

    public void setReportChanges(int newChanges) {
        boolean isChanged = false;
        if (this.reportChanges == 0 && newChanges > 0) {
            isChanged = true;
        } else if (this.reportChanges > 0 && newChanges == 0) {
            isChanged = true;
        }
        this.reportChanges = newChanges;
        this.fireReportDocumentStatusChangedListenerReportDocumentStatusChanged(new ReportDocumentStatusChangedEvent(this, isChanged));
    }

    public void incrementReportChanges() {
        this.setReportChanges(this.getReportChanges() + 1);
    }

    public void decrementReportChanges() {
        if (this.getReportChanges() > 0) {
            this.setReportChanges(this.getReportChanges() - 1);
        }
    }

    public boolean isModified() {
        return this.getReportChanges() > 0;
    }

    public boolean isLoadingFile() {
        return this.loadingFile;
    }

    public void setLoadingFile(boolean loading) {
        this.loadingFile = loading;
    }

    public synchronized void addReportDocumentStatusChangedListener(ReportDocumentStatusChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ReportDocumentStatusChangedListener.class, listener);
    }

    public synchronized void removeReportDocumentStatusChangedListener(ReportDocumentStatusChangedListener listener) {
        this.listenerList.remove(ReportDocumentStatusChangedListener.class, listener);
    }

    private void fireReportDocumentStatusChangedListenerReportDocumentStatusChanged(ReportDocumentStatusChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReportDocumentStatusChangedListener.class) continue;
            ((ReportDocumentStatusChangedListener)listeners[i + 1]).reportDocumentStatusChanged(event);
        }
    }

    public int getAvailableVerticalSpace() {
        int ph = this.getHeight();
        ph -= this.getTopMargin();
        ph -= this.getBottomMargin();
        for (int i = 0; i < this.getBands().size(); ++i) {
            Band b = (Band)this.getBands().elementAt(i);
            if (b.getName().equals("title") && this.isTitleNewPage || b.getName().equals("background") || b.getName().equals("summary") && this.isSummaryNewPage) continue;
            ph -= b.getHeight();
        }
        return ph;
    }

    public void setDefaultFont(IReportFont defaultFont) {
        this.defaultFont = defaultFont;
    }

    public static String writeEncodedColor(Color c) {
        String nums = "0123456789ABCDEF";
        String s = "#";
        s = s + nums.charAt(c.getRed() / 16);
        s = s + nums.charAt(c.getRed() % 16);
        s = s + nums.charAt(c.getGreen() / 16);
        s = s + nums.charAt(c.getGreen() % 16);
        s = s + nums.charAt(c.getBlue() / 16);
        s = s + nums.charAt(c.getBlue() % 16);
        return s;
    }

    public static String getCDATAString(String string, int tabCount) {
        String CRLF = System.getProperty("line.separator");
        String tab = "";
        for (int i = 0; i < tabCount; ++i) {
            tab = tab + "\t";
        }
        return "<![CDATA[" + string + "]]>";
    }

    public String getFormatFactoryClass() {
        return this.formatFactoryClass;
    }

    public void setFormatFactoryClass(String formatFactoryClass) {
        this.formatFactoryClass = formatFactoryClass;
    }
}

