/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.luna;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;

public class LunaIcons
extends BaseIcons {
    public static Icon getComboBoxIcon() {
        return LunaIcons.getDownArrowIcon();
    }

    public static Icon getUpArrowIcon() {
        if (upArrowIcon == null) {
            upArrowIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("luna/icons/small/arrow_up_7x6.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("luna/icons/medium/arrow_up_9x8.png") : new LazyImageIcon("luna/icons/large/arrow_up_11x10.png"));
        }
        return upArrowIcon;
    }

    public static Icon getDownArrowIcon() {
        if (downArrowIcon == null) {
            downArrowIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("luna/icons/small/arrow_down_7x6.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("luna/icons/medium/arrow_down_9x8.png") : new LazyImageIcon("luna/icons/large/arrow_down_11x10.png"));
        }
        return downArrowIcon;
    }

    public static Icon getLeftArrowIcon() {
        if (leftArrowIcon == null) {
            leftArrowIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("luna/icons/small/arrow_left_6x7.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("luna/icons/medium/arrow_left_8x9.png") : new LazyImageIcon("luna/icons/large/arrow_left_10x11.png"));
        }
        return leftArrowIcon;
    }

    public static Icon getRightArrowIcon() {
        if (rightArrowIcon == null) {
            rightArrowIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("luna/icons/small/arrow_right_6x7.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("luna/icons/medium/arrow_right_8x9.png") : new LazyImageIcon("luna/icons/large/arrow_right_10x11.png"));
        }
        return rightArrowIcon;
    }

    public static Icon getIconIcon() {
        if (iconIcon == null) {
            iconIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacIconIcon() : new TitleButtonIcon(0);
        }
        return iconIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            minIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacMinIcon() : new TitleButtonIcon(1);
        }
        return minIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            maxIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacMaxIcon() : new TitleButtonIcon(2);
        }
        return maxIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacCloseIcon() : new TitleButtonIcon(3);
        }
        return closeIcon;
    }

    private static class TitleButtonIcon
    implements Icon {
        private static final Color BLUE_FRAME_COLOR = Color.white;
        private static final Color BLUE_COLOR_LIGHT = new Color(154, 183, 250);
        private static final Color BLUE_COLOR_DARK = new Color(0, 69, 211);
        private static final Color CLOSER_COLOR_LIGHT = new Color(241, 172, 154);
        private static final Color CLOSER_COLOR_DARK = new Color(224, 56, 2);
        private static final int ICON_ICON_TYP = 0;
        private static final int MIN_ICON_TYP = 1;
        private static final int MAX_ICON_TYP = 2;
        private static final int CLOSE_ICON_TYP = 3;
        private int iconTyp = 0;

        public TitleButtonIcon(int typ) {
            this.iconTyp = typ;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int w = c.getWidth();
            int h = c.getHeight();
            JButton b = (JButton)c;
            Graphics2D g2D = (Graphics2D)g;
            boolean isActive = JTattooUtilities.isActive(b);
            boolean isPressed = b.getModel().isPressed();
            boolean isArmed = b.getModel().isArmed();
            boolean isRollover = b.getModel().isRollover();
            Color fc = BLUE_FRAME_COLOR;
            Color cHi = BLUE_COLOR_LIGHT;
            Color cLo = BLUE_COLOR_DARK;
            if (this.iconTyp == 3) {
                cHi = CLOSER_COLOR_LIGHT;
                cLo = CLOSER_COLOR_DARK;
            }
            if (!isActive) {
                cHi = ColorHelper.brighter(cHi, 20.0);
                cLo = ColorHelper.brighter(cLo, 10.0);
            }
            if (isPressed && isArmed) {
                Color cTemp = ColorHelper.darker(cLo, 10.0);
                cLo = ColorHelper.darker(cHi, 10.0);
                cHi = cTemp;
            } else if (isRollover) {
                cHi = ColorHelper.brighter(cHi, 30.0);
                cLo = ColorHelper.brighter(cLo, 30.0);
            }
            g2D.setPaint(new GradientPaint(0.0f, 0.0f, cHi, w, h, cLo));
            g.fillRect(1, 1, w - 2, h - 2);
            g.setColor(fc);
            g.drawLine(1, 0, w - 2, 0);
            g.drawLine(0, 1, 0, h - 2);
            g.drawLine(1, h - 1, w - 2, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.2f);
            g2D.setComposite(alpha);
            g2D.setColor(cLo);
            g.drawLine(2, 1, w - 2, 1);
            g.drawLine(1, 2, 1, h - 2);
            g2D.setColor(ColorHelper.darker(cLo, 40.0));
            g.drawLine(2, h - 2, w - 2, h - 2);
            g.drawLine(w - 2, 2, w - 2, h - 2);
            g2D.setComposite(composite);
            cHi = Color.white;
            cLo = ColorHelper.darker(cLo, 30.0);
            Icon icon = null;
            switch (this.iconTyp) {
                case 0: {
                    icon = new BaseIcons.IconSymbol(cHi, cLo, null, new Insets(0, 0, 0, 1));
                    break;
                }
                case 1: {
                    icon = new BaseIcons.MinSymbol(cHi, cLo, null, new Insets(0, 0, 0, 0));
                    break;
                }
                case 2: {
                    icon = new BaseIcons.MaxSymbol(cHi, cLo, null, new Insets(0, 0, 0, 1));
                    break;
                }
                case 3: {
                    icon = new BaseIcons.CloseSymbol(cHi, cLo, null, new Insets(0, 0, 0, 1));
                    break;
                }
            }
            if (icon != null) {
                icon.paintIcon(c, g, 0, 0);
            }
        }
    }
}

